/***********************************************************************
*                                                                      *
*     unendl.                                                          *
* pi= Summe [ 1/16^i * ( (4/8i+1) - (2/8i+4) - (1/8i+5) - (1/8i+6) ) ] *
*      i=0                                                             *
*                                                                      *
* Dieses Programm dient der Berechnung von Pi auf 100.000 Stellen nach *
* dem Komma.                                                           *
* Da die Anzahl der mglichen Stellen der Standardvariablen unzurei-   *
* chend ist, werden die Zahlen nicht als komplette Zahlen, sondern als *
* char-Arrays gespeichert. Die Elemente vom Typ char werden als ein-   *
* stellige ganzzahlige Werte behandelt, die sich ohne Schwierigkeiten  *
* addieren, subtrahieren usw. lassen.                                  *
*                                                                      *
* Dabei wird die erste Nachkommastelle von Pi im 0. Element abgelegt,  *
* die zweite im 1. Element usw. Im Fall von szhz[] wird die            *
* Einerstelle im letzten Element (STELLENZAHL) abgelegt, die Zehner-   *
* stelle im vorletzten Element (STELLENZAHL-1) usw. Also praktisch von *
* links nach rechts, so wie man schreibt. Natrlich mssen auch die    *
* Nullen vor der eigentlichen szhz mitgeschrieben werden.              *
* Diese Anordnung bleibt auch bei der Sicherung in den Dateien         *
* erhalten.                                                            *
*                                                                      *
* Die Rechenoperationen erfolgen nach dem gleichen Algorithmus, wie    *
* beim schriftlichen Rechnen auf dem Papier.                           *
*                                                                      *
* Die Ausgabe der Arrays auf im Textformat benutzt den Operator        *
* static_cast aus iostream.h.                                          *
*                                                                      *
* Die folgenden Werte werden in Dateien zwischengespeichert:           *
* Zhler     alias  zaehler    in      zaehler.dat                     *
* 16^Zhler  alias  szhz       in         szhz.dat                     *
* Pi         alias  pi         in           pi.dat                     *
*                                                                      *
* Sie werden auch als globale Variablen definert, da sie von nahezu    *
* allen Funktionen aufgerufen werden.                                  *
*                                                                      *
* In der Variable pi[] und der Datei pi.dat werden nur die Nachkomma-  *
* stellen gespeichert, da sich die 3 vor dem Komma in der Berechnung   *
* nicht bemerkbar macht und das Komma so nicht bercksichtigt werden   *
* muss.                                                                *
*                                                                      *
***********************************************************************/

#include <iostream>
#include <fstream>
#include <conio.h>
//#include <io.h>

// Definition der globalen Variablen

int STELLENZAHL;  //  bestimmt die Genauigkeit der Rechnung, je mehr Stellen, desto unbedeutender die Rundungsfehler
                  //  nicht mit Zhler verwechseln
int GENAUIGKEIT;  //  bestimmt, bis zu welcher Stelle Pi bearbeitet werden soll

int zaehler;        /*  entspricht dem i in der Gleichung, darf
                    hchstens STELLENZAHL/lg16 gro sein, sonst passt
                    16^Zhler nicht mehr in szhz[STELLENZAHL] */
int genau_max;      /* maximale Genauigkeit, Mit grer werdendem zaehler
                    findet die Verbesserung der Genauigkeit von Pi an immer
                    weiter hinten stehenden Stellen statt. genau_max zhlt diese
                    Stelle. Da Rundungsfehler mglich bleiben, wenn die
                    STELLENZAHL nicht angemessen gewhlt wurde, gibt genau_max
                    _nicht unbedingt_ die letzte genaue Stelle vin Pi an! */

char statusflag;

/* Vorbereitung der Arrays: Um die Arrays zur Laufzeit zu Deklarieren und an die
   Wnsche des Nutzers anzupassen werden sie in der Funktion initialisierung()
   mittels new() erzeugt und ber Pointerarithmetik gehandhabt. Damit sie global
   gltig sind, werden hier bereits die ntigen Pointer deklariert (Die Funktion
   new() liefert nur Pointer zurck.) */

char *pi;               //  Pi
char *szhz;             //  16^Zhler
char *rueckgabe_array;  /*  ist ntig, weil lokale Arrays von Funktionen nicht
                            zurckgegeben werden knnen. (Referenz auf zerstrte
                            Variable)  Mag sein, das geht auch eleganter. */



// Prototypen

void initialisierung(void);
void berechne(void);
void programm_beenden(void);

using namespace std;

int main(void)
{
initialisierung();
berechne();
cout<<endl<<endl;
programm_beenden();

delete [] pi;
delete [] szhz;
delete [] rueckgabe_array;

std::cout<<"Programm beendet. Weiter mit beliebiger Taste.";
while (!kbhit());  // Warten

return(0);
}


/** Hilfsfunktionen

Dieser Abschnitt enthlt folgende Funktionen:

1. zwischenspeichern() --> Speicherung der Zwischenergebnisse
2. programm_beenden()  --> Abschluss des Rechenvorganges, Endspeicherung
3. kleiner_als()       --> vergleicht zwei Arrays



**/

void zwischenspeichern(void)
/* Diese Funktion speichert die Werte fr
zaehler, szhz[] und pi[] ab, um den Zeitverlust bei einem mglichen
Computerabsturz zu verhindern. */
{
int zaehler_lokal;  //  lokaler Zhler != zaehler

// Zwischenspeichern von zaehler
std::ofstream dat_file1("zaehler.dat", std::ios::out);
dat_file1<<zaehler;
dat_file1.close();

// Zwischenspeichern von szhz[]
ofstream dat_file2("szhz.dat", ios::out);

for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  {
  dat_file2<<static_cast<int>(*(szhz+zaehler_lokal));
  };
dat_file2.close();

// Zwischenspeichern von pi[]
ofstream dat_file3("pi.dat", ios::out);
for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  dat_file3<<static_cast<int>(*(pi+zaehler_lokal));
dat_file3.close();

}  //  Ende der Funktion zwischenspeichern()


void programm_beenden(void)
{
int zaehler_lokal;

cout<<"Rechnung beendet.\n";
cout<<"Die aktuellen Werte werden gesichert.\n";
zwischenspeichern();
cout<<"Die aktuellen Werte wurden gesichert.\n\n";


//  Speicherung der Werte im ASCII-Format

cout<<"Werte werden in Text umgewandelt und in die Dateien geschrieben.\n\n";

// Speicherung von zaehler in der Datei zaehler.txt
ofstream txt_file1("zaehler.txt", ios::out);
txt_file1<<"Berechnung der Kreiskonstanten\n------------------------------\n\n";
txt_file1<<"Der Zaehler stand am Ende der Berechnung bei:\n\n";
txt_file1<<zaehler;
txt_file1.close();

// Speicherung von szhz[] in der Datei szhz.txt
ofstream txt_file2("szhz.txt", ios::out);
txt_file2<<"Berechnung der Kreiskonstanten\n------------------------------\n\n";
txt_file2<<"16 hoch "<<zaehler<<" = \n\n";

int fuehrungsnull=1;  /*  Fhrende Nullen sollen bei szhz im Textformat
                      nicht mit abgespeichert werden. Erst wenn die erste
                      Ziffer ungleich Null auftaucht, werden alle folgenden
                      Ziffern gespeichert.*/

for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  {
  if (*(szhz+zaehler_lokal) != 0) fuehrungsnull=0;
  if (!fuehrungsnull) txt_file2<<static_cast<int>(*(szhz+zaehler_lokal));
  }
txt_file2.close();

// Speicherung von pi[] in der Datei pi.txt
ofstream txt_file3("pi.txt", ios::out);
txt_file3<<"Berechnung der Kreiskonstanten\n------------------------------\n\n";
txt_file3<<"Nach "<<zaehler<<" Durchlufen wurde fr Pi \nmit einer Genauigkeit von hchstens "<<genau_max<<" Stellen \nfolgender Wert berechnet:\n\n";
txt_file3<<"3,\n";  //  Ergnzung der Vorkommanstelle und des Kommas
for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  {
  if (zaehler_lokal%1000 == 0)
    txt_file3<<endl<<endl;           // Leerzeile nach 1000 Stellen
    else
      if (zaehler_lokal%100 == 0)
        txt_file3<<endl;           // Neue Zeile nach 100 Stellen
        else
          if (zaehler_lokal%10 == 0)
            txt_file3<<' ';         // Leerzeichen nach allen 10 Stellen
  txt_file3<<static_cast<int>(*(pi+zaehler_lokal));
  };
txt_file3.close();


}  //  Ende der Funktion programm_beenden()


 bool kleiner_als(char wert1[], char wert2[], int groesse1, int ungleich)
/* wird bentigt fr die Division, bestimmt, ob der Array wert1 oder der Array
wert2 die kleinere Zahl enthlt
Achtung! Funktioniert nur, wenn die Stelle 10^0 auf wert[groesse-1] abgelegt wurde usw.

Wird an zwei Stellen aufgrufen: beim einzelnen Divisionsschritt (// Rechnung)
und bei der berprfung nach ganzzahligem Ergebnis des berschlages.
Im ersten Fall ist groesse1 == szhz_laenge+1 und groesse2 == szhz_laenge.
Im zweiten Fall sind groesse1 und groesse2 == szhz_laenge.
*/

{
bool rueckgabe;
int zaehler_lokal;

if ((ungleich) && (wert1[0] != 0))  // Wenn das erste Array eins lnger ist,
  {                                 // und im im O. Element keine 0 steht, dann
  rueckgabe=false;                  // kann der erste Array nicht kleiner als
  }                                 // der zweite sein.
  else
    {
    for (zaehler_lokal=0; zaehler_lokal<=(groesse1-(1+ungleich)); zaehler_lokal++)
      if (wert1[zaehler_lokal+ungleich]!=wert2[zaehler_lokal])
        if (wert1[zaehler_lokal+ungleich]<wert2[zaehler_lokal])
          {
          rueckgabe=true;
          zaehler_lokal=groesse1;
          }
          else
            {
            rueckgabe=false;
            zaehler_lokal=groesse1;
            };
    };       

return(rueckgabe);

}  //  Ende der Funktion kleiner_als


void hilfe1(int option)
{
cout<<"\n\n"
      "HILFE:\n"
      "Die Berechnung erfolgt, indem immer kleiner werdende Zahlen miteinander addiert\n"
      "werden. Das fuehrt dazu, dass an den hinteren Stellen von PI immer noch\n"
      "Veraenderungen auftreten, waehrend es im vorderen Bereich schon sichere\n"
      "Stellen gibt, an denen sich nichts mehr aendern wird. Die Anzahl dieser Stellen\n"
      "wird durch GENAUIGKEIT bestimmt.\n"
      "Damit GENAUIGKEIT aber wirklich der Genauigkeit von PI entspricht, muss die\n"
      "Berechnung mit einer STELLENZAHL durchgefuehrt werden, die ueber GENAUIGKEIT\n"
      "liegt. Nur so sind Rundungsfehler zu vermeiden. Je groesser STELLENZAHL ist,\n"
      "desto geringer ist die Gefahr eines Rundungsfehlers. Es hat sich gezeigt, dass\n"
      "es genuegt, wenn STELLENZAHL etwa 1% ueber GENAUIGKEIT liegt.\n\n";
if (!option) cout<<"(f/v) ";
}  //  Ende der Funktion hilfe1


void hilfe2(void)
{
cout<<"\n\n"
      "HILFE:\n"
      "Es ist moeglich, die Ergebnisse der vorherigen Berechnung fuer die neue\n"
      "zu nutzen, wenn die neue Berechnung mit einer geringerer STELLENZAHL\n"
      "durchgefuehrt werden soll. So kann die Rechnung beschleunigt werden. Dies\n"
      "kann allerdings auch zu einer Absenkung der Genauigkeit fuehren. Solange\n"
      "GENAUIGKEIT jedoch 1% ueber STELLENZAHL liegt, sind Rundungsfehler nicht\n"
      "zu erwarten. (Dass die GENAUIGKEIT nicht ueber STELLENZAHL liegen kann,\n"
      "duerfte offensichtlich sein.)\n\n"
      "(w/n) ";
}  //  Ende der Funktion hilfe2


/** Ende der Hilfsfunktionen **/




/** Initialisierungsteil

Der Initialisierungsteil besteht aus drei Funktionen:
1. dateien_vorbereiten()
2. dateien_auslesen()
3. initialisierung()

Die Berechnung wird vermutlich einige Zeit in Anspruch nehmen. Daher
ist es vorgesehen, die Berechnung zu unterbrechen und zu einem spteren
Zeitpunkt wieder aufzunehmen. Dazu werden bei jedem Aufruf des Programms
die Variablen durch die Funktion dateien_auslesen auf den aktuellen Stand
gebracht.

Beim ersten Aufruf des Programms mssen deshalb die drei im Programmkopf
aufgefhrten Dateien durch die Funktion dateien_vorbereiten in den
Ausgangszustand versetzt werden. Beim Ausgangszustand handelt es sich um
den Zustand, als sei der Rechenvorgang fr zaehler=0 schon erfolgt.
Das heit: zaehler=0
           szhz=1
           pi=1333333... .

Die Funktion initialisierung gibt eine Begrungsmeldung aus, fragt die
Einstellungen ab und koordiniert die Funktionen dateien_vorbereiten und
dateien_auslesen.

**/


void dateien_vorbereiten(void)
{
int zaehler_lokal;  //  lokaler Zhler != zaehler

// Initialisierung der Datei zaehler.dat
zaehler=0;
ofstream dat_file1("zaehler.dat", ios::out);
dat_file1<<zaehler;
dat_file1.close();

// Initialisierung der Datei szhz.dat
for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-2); zaehler_lokal++)
  *(szhz+zaehler_lokal)=0;
*(szhz+STELLENZAHL-1)=1;
ofstream dat_file2("szhz.dat", ios::out);
for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  dat_file2<<*(szhz+zaehler_lokal);
dat_file2.close();

// Initialisierung der Datei pi.dat
for (zaehler_lokal=1; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  *(pi+zaehler_lokal)=3;
*pi=1;
ofstream dat_file3("pi.dat", ios::out);
for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  dat_file3<<*(pi+zaehler_lokal);
dat_file3.close();


}  //  Ende der Funktion dateien_vorbereiten


void dateien_auslesen(void)
{
int zaehler_lokal;  //  lokaler Zaehler != zaehler
char umweg;

// Auslesen der Datei zaehler.dat
ifstream dat_file1("zaehler.dat", ios::in);
dat_file1>>zaehler;
dat_file1.close();

// Auslesen der Datei szhz.dat
ifstream dat_file2("szhz.dat", ios::in);
for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  {
  dat_file2>>umweg;
  switch (umweg)
    {
    case '0': *(szhz+zaehler_lokal)=0; break;
    case '1': *(szhz+zaehler_lokal)=1; break;
    case '2': *(szhz+zaehler_lokal)=2; break;
    case '3': *(szhz+zaehler_lokal)=3; break;
    case '4': *(szhz+zaehler_lokal)=4; break;
    case '5': *(szhz+zaehler_lokal)=5; break;
    case '6': *(szhz+zaehler_lokal)=6; break;
    case '7': *(szhz+zaehler_lokal)=7; break;
    case '8': *(szhz+zaehler_lokal)=8; break;
    case '9': *(szhz+zaehler_lokal)=9; break;
    default: /* nix tun */ ;
    };
  };
dat_file2.close();

// Auslesen der Datei pi.dat
ifstream dat_file3("pi.dat", ios::in);
for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  {
  dat_file3>>umweg;
  switch (umweg)
    {
    case '0': *(pi+zaehler_lokal)=0; break;
    case '1': *(pi+zaehler_lokal)=1; break;
    case '2': *(pi+zaehler_lokal)=2; break;
    case '3': *(pi+zaehler_lokal)=3; break;
    case '4': *(pi+zaehler_lokal)=4; break;
    case '5': *(pi+zaehler_lokal)=5; break;
    case '6': *(pi+zaehler_lokal)=6; break;
    case '7': *(pi+zaehler_lokal)=7; break;
    case '8': *(pi+zaehler_lokal)=8; break;
    case '9': *(pi+zaehler_lokal)=9; break;
    default: /* nix tun */ ;
    };
  };
dat_file3.close();

}  //  Ende der Funktion dateien_auslesen


void initialisierung(void)
{

// Auslesen der Datei init.dat
// zur Bestimmung von GENAUIGKEIT und STELLENZAHL der verfgbaren Dateien
// und zur berprfung, ob Daten einer alten Berechnung vorliegen init.dat
// wird hier reprsentativ fr alle dat-Files betrachtet
ifstream dat_file1("init.dat", ios::in);
//int handle;
if (!(dat_file1.bad()))   // Wenn init.dat existiert, ...
  {
  
//  dat_file1.open("init.dat", ios::in);
  dat_file1>>GENAUIGKEIT;
  dat_file1>>STELLENZAHL;
  dat_file1.close();

  // berschrift, Anzeige der Optionen

  cout<<"Berechnung der Kreiskonstanten PI                                 [ENDE  mit x]\n"
        "---------------------------------                                 [HILFE mit h]\n\n";


  // Abfrage, ob alte Berechnung weitergefhrt oder verndert werden soll
  // do-while-Schleifen sichern passende Eingaben

  cout<<"Es liegt eine angefangene Berechnung vor. Soll diese Berechnung fortgesetzt\n"
        "oder sollen die Einstellungen (GENAUIGKEIT = "<<GENAUIGKEIT<<"; STELLENZAHL = "<<STELLENZAHL<<")\n"
        "veraendert werden? (f/v) ";

  char abfrage1, abfrage2;

  do
    {
    cin>>abfrage1;
    if (abfrage1 == 'V') abfrage1='v';  //  Bercksichtigung groer Buchstaben
    if (abfrage1 == 'F') abfrage1='f';
    if ((abfrage1 == 'X') || (abfrage1 == 'x')) exit(0);
    if ((abfrage1 == 'H') || (abfrage1 == 'h')) hilfe1(0);
    }
    while ((abfrage1 != 'v') && (abfrage1!='f'));
  cout<<endl;

  // Rechnung soll fortgesetzt werden
  if (abfrage1 == 'f')
    {
    //  Intialisierung der globalen Arrays
    if ((STELLENZAHL-GENAUIGKEIT) < 2) STELLENZAHL=GENAUIGKEIT+2;
    pi = new char[STELLENZAHL];
    szhz = new char[STELLENZAHL];
    rueckgabe_array = new char[STELLENZAHL];
    };

  // Rechnung soll verndert werden
  if (abfrage1 == 'v')
    {
/*    cout<<"Sollen die vorliegenden Ergebnisse weiter verwendet oder eine\n"
          "komplett neue Rechnung begonnen werden? (w/n) ";
    do
      {
      abfrage2=getchar();
      if (abfrage2 == 'W') abfrage2='w';  //  Bercksichtigung groer Buchstaben
      if (abfrage2 == 'N') abfrage2='n';
      if ((abfrage2 == 'X') || (abfrage2 == 'x')) exit(0);
      if ((abfrage2 == 'H') || (abfrage2 == 'h')) hilfe2();
      }
      while ((abfrage2 != 'w') && (abfrage2 != 'n'));
    cout<<abfrage2<<endl<<endl;
  */
    cout<<"Bitte Werte fuer GENAUIGKEIT und STELLENZAHL eingeben!\n";

    if (0) //(abfrage2 == 'w')
      {
      cout<<"GENAUIGKEIT (min=1; max="<<GENAUIGKEIT<<"): "; cin>>GENAUIGKEIT;
      cout<<"STELLENZAHL (min="<<(GENAUIGKEIT+2)<<"; max="<<STELLENZAHL<<"): "; cin>>STELLENZAHL; cout<<endl;

      //  Intialisierung der globalen Arrays
      if ((STELLENZAHL-GENAUIGKEIT) < 2) STELLENZAHL=GENAUIGKEIT+2;
      pi = new char[STELLENZAHL];
      szhz = new char[STELLENZAHL];
      rueckgabe_array = new char[STELLENZAHL];

      };
    if (1) //(abfrage2 == 'n')
      {
      cout<<"GENAUIGKEIT (min=1; max=2147483645): "; cin>>GENAUIGKEIT; cout<<endl;
      cout<<"STELLENZAHL (min="<<(GENAUIGKEIT+2)<<"; max=2147483647): "; cin>>STELLENZAHL; cout<<endl;

      //  Intialisierung der globalen Arrays
      if ((STELLENZAHL-GENAUIGKEIT) < 2) STELLENZAHL=GENAUIGKEIT+2;
      pi = new char[STELLENZAHL];
      szhz = new char[STELLENZAHL];
      rueckgabe_array = new char[STELLENZAHL];


      dateien_vorbereiten();
      cout<<"Die alten Daten wurden geloescht.\n";
      };

    };  // Ende von  Rechnung soll verndert werden

  } //  Ende von  Wenn init.dat existiert, ...

  else  //  Wenn init.dat nicht existiert, ...
    {
    // berschrift, Anzeige der Optionen

    cout<<"Berechnung der Kreiskonstanten PI\n"
          "---------------------------------\n\n";


    cout<<"Eine neue Rechnung wird begonnen. Bitte Werte fuer GENAUIGKEIT und\n"
          "STELLENZAHL eingeben!";
    hilfe1(1);
    cout<<endl<<endl;
    cout<<"GENAUIGKEIT (min=1; max=2147483645): "; cin>>GENAUIGKEIT; cout<<endl;
    cout<<"STELLENZAHL (min="<<(GENAUIGKEIT+2)<<"; max=2147483647): "; cin>>STELLENZAHL; cout<<endl;

    //  Intialisierung der globalen Arrays
    if ((STELLENZAHL-GENAUIGKEIT) < 2) STELLENZAHL=GENAUIGKEIT+2;
    pi = new char[STELLENZAHL];
    szhz = new char[STELLENZAHL];
    rueckgabe_array = new char[STELLENZAHL];

    dateien_vorbereiten();
    };


// Speicherung von GENAUIGKEIT und STELLENZAHL in init.dat
ofstream dat_file2("init.dat", ios::out);
dat_file2<<GENAUIGKEIT<<endl<<STELLENZAHL;
dat_file2.close();


// Die Dateien werden ausgelesen und in die Variablen geschrieben
cout<<"Die Variablen werden fuer die Rechnung vorbereitet.\n";
dateien_auslesen();
cout<<"Variablen sind vorbereitet.\n\n";

system ("cls"); //  Notlsung zum Lschen des Bildschirms unter DOS

cout<<"Berechnung der Kreiskonstanten PI                                 [ENDE  mit x]\n"
      "---------------------------------\n\n"
      "auf "<<GENAUIGKEIT<<" Stellen nach dem Komma.\n\n\n";



}  //  Ende der Funktion initialisierung

/** Ende des Initialisierungsteils **/


/** Berechnungsteil

Im Berechnungsteil werden die einzelnen Funktionen definiert, aus denen
sich die Berechnung zusammensetzt. Dazu gehren:

1. erhoehe_szhz()   --> Berechnung von 16^Zhler
2. division()       --> Dividiert Ganze Zahlen
3. verbessere_pi()  --> Errechnung der ntigen Werte zur Verbesserung Pis,
                        Addition zu Pi
4. berechne()       --> Koordinierung der obigen Funktionen, Zwischenausgabe,
                        zwischenspeichern


**/

void erhoehe_szhz(void)
{
/* Zur Erhhung von szhz[] muss szhz[] mit 10 und 6 multipliziert werden. Die
Ergebnisse werden danach addiert uns nach szhz[] zurckgeschrieben.

Die Multiplikation mit 10 erfolgt indem szhz[x] an die Stelle szhz[x-1]
verschoben wird. An die Stelle szhz[0] wird eine 0
geschrieben. Das Ergebnis wird in einem weiteren Array mal_10 gespeichert.

Die Multiplikation mit 6 erfolgt indem szhz[] von einem Character in
einen Integerwert umgewandelt und mit 6 schrittweise "schriftlich"
multipliziert wird. Das Ergebnis wird in einem weiteren Array mal_6
gespeichert.

Nach der "schriftlichen" Methode werden die Arrays mal_10 und mal_6
addiert und in szhz[] abgelegt.*/


char mal_10[STELLENZAHL];
char mal_6[STELLENZAHL];

int zaehler_lokal;

char merke, zwischenergebnis;

// Multiplikation mit 10

for (zaehler_lokal=1; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  mal_10[zaehler_lokal-1]=*(szhz+zaehler_lokal);
mal_10[STELLENZAHL-1]=0;


// Multiplikation mit 6

merke=0;
for (zaehler_lokal=(STELLENZAHL-1); zaehler_lokal>=0; zaehler_lokal--)
  {
  zwischenergebnis=*(szhz+zaehler_lokal)*6;
  zwischenergebnis=zwischenergebnis+merke;
  mal_6[zaehler_lokal]=zwischenergebnis%10;
  merke=(zwischenergebnis-zwischenergebnis%10)/10;
  };

// Der letzte bertrag erfolgt, indem er zur Fhrungsnull addiert und
// als zwischenergebnis an die Spitze von mal_6[] gestellt wird.
// Das gleiche Prinzip wird auch im folgenden verwendet.

// Addition der Ergebnisse

merke=0;
for (zaehler_lokal=(STELLENZAHL-1); zaehler_lokal>=0; zaehler_lokal--)
  {
  zwischenergebnis=mal_10[zaehler_lokal]+mal_6[zaehler_lokal];
  zwischenergebnis=zwischenergebnis+merke;
  *(szhz+zaehler_lokal)=zwischenergebnis%10;
  merke=(zwischenergebnis-zwischenergebnis%10)/10;
  }

}  //  Ende der Funktion erhoehe_szhz


void division(int divident, int divisor)
{
// fhrt die Division zweier Integerzahlen durch
// Achtung! Funktioniert nur, wenn Divident < Divisor.

int zaehler_lokal;
char quotient[STELLENZAHL];
char schreibe;

// Initialisierung der Variablen

divident*=10;  // Gleichbedeutend mit divident=divident*10

for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  quotient[zaehler_lokal]=0;

// divident und quotient[] wurden so initialisiert, als sei der erste
// Divisionsschritt schon durchgefhrt, das Komma gesetzt und der Divident
// schon zu divident*10 geworden.


for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  {
    if (divident<divisor)
    // Solange der divident < divisor soll der Divident verzehnfacht und
    // quotient[] eine Nachkommanull hinzugefgt werden.
      {
      schreibe=0;
      divident*=10;
      }
      else
        {
        /***********************************************************************

        Auf Grund der vorherigen Bestimmungen haben wir es an dieser
        Stelle nur mit einer sehr einfachen Divisionsvariante zu tun.

        1. Kommata kommen nicht mehr vor, weil wir nur mit Ganzen Zahlen rechnen
           und zwar so, dass immer Zahlen<1 herauskommen, deren Vorkommastellen
           nicht bercksichtigt werden mssen.
        2. Der Divident ist immer grer als der Divisor, weil wir uns schon im
           else-Teil einer entsprechenden Abfrage befinden.
        3. Der Divident ist weniger als 10 mal grer als der Divisor, weil zu
           Beginn jeder Rechnung der Divisor grer ist als der Divident. Und
           der Divident im Verlauf der schriftlichen Division nur vergrert
           wird, wenn er kleiner ist als der Divisor und dann auch nur um den
           Faktor 10, so dass der neue Divident nur x*10 (fr x<1) grer sein
           kann als der Divisor. Der Divisor bleibt dabei konstant.

        ***********************************************************************/

        schreibe=divident/divisor;
        divident=(divident-(schreibe*divisor))*10;

        }
    quotient[zaehler_lokal]=schreibe;
  };


rueckgabe_array=&quotient[0];

}  //  Ende der Funktion Quotient


void verbessere_pi(void)
{
int zaehler_lokal;


// Berechne Faktor2 = 4/(8i+1) - 2/(8i+4) - 1/(8i+5) - 1/(8i+6)

char faktor2[STELLENZAHL];

  // Berechne Minuend:  4/(8i+1)

  char minuend[STELLENZAHL];

  division(4, (8*zaehler+1));
  for (zaehler_lokal=0; zaehler_lokal<STELLENZAHL; zaehler_lokal++)
    minuend[zaehler_lokal]=*(rueckgabe_array+zaehler_lokal);


  // Berechne Subtrahent1:  2/(8i+4)

  char subtrahent1[STELLENZAHL];

  division(2, (8*zaehler+4));
  for (zaehler_lokal=0; zaehler_lokal<STELLENZAHL; zaehler_lokal++)
    subtrahent1[zaehler_lokal]=*(rueckgabe_array+zaehler_lokal);


  // Berechne Subtrahent2:  1/(8i+5)

  char subtrahent2[STELLENZAHL];

  division(1, (8*zaehler+5));
  for (zaehler_lokal=0; zaehler_lokal<STELLENZAHL; zaehler_lokal++)
    subtrahent2[zaehler_lokal]=*(rueckgabe_array+zaehler_lokal);


  // Berechne Subtrahent3:  1/(8i+6)

  char subtrahent3[STELLENZAHL];

  division(1, (8*zaehler+6));
  for (zaehler_lokal=0; zaehler_lokal<STELLENZAHL; zaehler_lokal++)
    subtrahent3[zaehler_lokal]=*(rueckgabe_array+zaehler_lokal);


   // Addiere Subtrahent1+Subtrahent2+Subtrahent3=Subtrahenten

   char subtrahenten[STELLENZAHL];
   char merke, zwischenergebnis;

   merke=0;
   for (zaehler_lokal=(STELLENZAHL-1); zaehler_lokal>=0; zaehler_lokal--)
     {
     zwischenergebnis=subtrahent1[zaehler_lokal]+subtrahent2[zaehler_lokal]+subtrahent3[zaehler_lokal];
     zwischenergebnis+=merke;
     subtrahenten[zaehler_lokal]=zwischenergebnis%10;
     merke=(zwischenergebnis-zwischenergebnis%10)/10;
     };


// Subtrahiere Minuend-Subtrahent=Faktor2

merke=0;
for (zaehler_lokal=(STELLENZAHL-1); zaehler_lokal>=0; zaehler_lokal--)
  {
  if (minuend[zaehler_lokal]>=(subtrahenten[zaehler_lokal]+merke))
    {
    faktor2[zaehler_lokal]=minuend[zaehler_lokal]-(subtrahenten[zaehler_lokal]+merke);
    merke=0;
    }
    else
      {
      faktor2[zaehler_lokal]=(minuend[zaehler_lokal]+10)-(subtrahenten[zaehler_lokal]+merke);
      merke=1;
      }
  };


char verbesserung[STELLENZAHL];

/* Dieser Programmteil dividiert den Array faktor2[] mit dem Array szhz[].
Die Division erfolgt indem die Zahl
aus faktor2[] mit der Zahl aus szhz[] dividiert wird. Die Division wird
durchgefhrt bis beim Ergebnis ein Komma gesetzt werden msste, das heit,
bis aus faktor2 keine Ziffern mehr zur Division heruntergezogen werden
knnen.
Das Ergebnis ist also eine ganze Zahl, die in den Array verbesserung[]
geschrieben werden kann, und zwar so, dass die Einerstelle des Ergebnisses
an die letzte Stelle von verbesserung[] kommt, die Zehnerstelle an die
vorletzte usw.

Bsp.:          |0|1|2|3|4|
      faktor2  |0|3|0|7|2|  = 0,03072
      szhz     |0|0|2|5|6|  = 256

      Gerechnet wird 03072/00256, also 3072/256. Das ergibt 12. Also
                             |0|1|2|3|4|
      kommt in verbesserung: |0|0|0|1|2| = 0,00012. Das entspricht genau
      dem Ergebnis von 0,03072/256.

*/

// Initialisierung der Variablen

for (zaehler_lokal=0; zaehler_lokal<=(STELLENZAHL-1); zaehler_lokal++)
  verbesserung[zaehler_lokal]=0;


// Zuerst wird die _Lnge_ von szhz ohne die fhrenden Nullen ermittelt.

int szhz_laenge = STELLENZAHL;

zaehler_lokal=0;
while (*(szhz+zaehler_lokal) == 0)
  {
  szhz_laenge--;
  zaehler_lokal++;
  };

// szhz[] wird um die fhrenden Nullen verkrzt in einen neuen Array namens
// szhz_div[szhz_laenge] geschrieben.

char szhz_divisor[szhz_laenge];

for (zaehler_lokal=1; zaehler_lokal<=szhz_laenge; zaehler_lokal++)
  szhz_divisor[(szhz_laenge-zaehler_lokal)]=*(szhz+STELLENZAHL-zaehler_lokal);


/* Bei der schriftlichen Division wird nicht der gesamte Divident auf
einmal mit dem Divisor dividiert, sondern von vorn nach hinten immer nur
so viele Stellen wie ntig sind, ein einstelliges ganzzahliges Ergebnis
grer als Null zu erhalten. Das sind mindestens so viele Stellen wie der
Divisor hat und hchstens eine mehr als dieser.
Dem entsprechend bentigt man zur Division hier auch nur einen Ausschnitt
des Dividenten. Dieser Ausschnitt wird sich ab dem zweiten Schritt auch
zum grten Teil aus dem Rest des vorherigen Divisionsschrittes zusammen-
setzen. */

char faktor2_divident[szhz_laenge+1];

for (zaehler_lokal=0; zaehler_lokal<=szhz_laenge; zaehler_lokal++)
  faktor2_divident[zaehler_lokal]=0;


char quotient[STELLENZAHL];  // In dieser Variablen wird das Divisionsergebnis
                               // abgelegt, bevor es in der passenden Form in
                               // verbesserung[] geschrieben wird.

char rueckrechnung[szhz_laenge+1];  // Das Ergebnis des Divisionsschrittes wird
                                    // mit dem Divisor multipliziert und das
                                    // Produkt vom Dividenten abgezogen, um den
                                    // Rest und damit den ersten Teil des neuen
                                    // Dividenten zu bestimmen.

int quotient_stelle=0;  // zhlt die Elemente des Ergebnisarrays durch
char schreibe;          // Zwischenergebnis eines einzelnen Divisionsschrittes
int faktor2_divident_ueberschlag=0,
    szhz_divisor_ueberschlag=0,
    naechste_stelle,
    zehnerpotenz;

// Bestimmung des berschlags fr szhz_divisor[], nur einmal fr jeden Durchlauf
// ntig
if (szhz_laenge>=4)
  szhz_divisor_ueberschlag=1000*szhz_divisor[0]+
                           100*szhz_divisor[1]+
                           10*szhz_divisor[2]+
                           szhz_divisor[3];
  else
    {
    for (zaehler_lokal=0; zaehler_lokal<=(szhz_laenge-1); zaehler_lokal++)
      {
      naechste_stelle=szhz_divisor[zaehler_lokal];
      for (zehnerpotenz=(szhz_laenge-1-zaehler_lokal); zehnerpotenz>=1; zehnerpotenz-- )
        naechste_stelle*=10;
      szhz_divisor_ueberschlag+=naechste_stelle;
      };
    };

// Beginn der Division
for (int faktor2_position=0 ; faktor2_position<=(STELLENZAHL-1); faktor2_position++)
  {
  if (kbhit())
    {
    statusflag=getch();
    if (statusflag == 'X')
      statusflag='x';
    if (statusflag == 'x')
      cout<<"\n\nDas Programm wird nach Abschluss dieses Rechenschrittes beendet.\n"
                "Um das Programm doch fortzusetzen bitte eine beliebige andere Taste druecken.\n\n";
    }

  // faktor2_divident wird fr den folgenden Rechenschritt vorbereitet:
  // "(Nchste) Zahl runterholen".
  for (zaehler_lokal=0; zaehler_lokal<=(szhz_laenge-1); zaehler_lokal++)
    faktor2_divident[zaehler_lokal]=faktor2_divident[zaehler_lokal+1];
  faktor2_divident[szhz_laenge]=faktor2[faktor2_position];


  // Rechnung

  if (kleiner_als(faktor2_divident, szhz_divisor, (szhz_laenge+1), 1))
  /* Der dritte Parameter gibt die Lnge des greren Arrays an.
  Der vierte Parameter (1) gibt an, dass die Arrays ungleich viel Elemente haben.
  Daraus leitet die Funktion die Gre des kleineren zweiten Arrays ab, nmlich 
  szhz_laenge. Diese etwas undurchsichtigen Parameter vereinfachen und beschleunigen
  die sehr hufig aufgerufene Funktion kleiner_als bedeutend. */
    {
    schreibe=0;
    }
    else
      {
      /* Hier wird der Array faktor2_divident[] mit dem Array szhz_divisor[]
      dividiert.
      Das Ergebnis kann nur zwischen 1 und 9 liegen. Das hat folgende Grnde:
      1. faktor2_divident[] ist grer als szhz_divisor[] (Siehe if-Abfrage
         dieses else-Abschnittes!). --> Ergebnis grer als 1
      2. faktor2_divident[] hat entweder genausoviele Stellen hat wie
         szhz_divisor[] oder hchstens eine mehr.
         2.1. Wenn faktor2_divident genausoviele Stellen hat wie szhz_divisior[],
              muss das Ergebnis kleiner sein als 10.
         2.2. faktor2_divident[] hat nur dann eine Stelle mehr als
              szhz_divisor[], wenn der vorherige Divisionsschritt 0 zum Ergebnis
              hatte, das heit, eine Zahl kleiner als 1. Wird an den Dividenten
              unter diesen Umstnden eine Stelle angehngt, dann bleibt das
              Ergebnis des neuen Divisionsschrittes unter 10.

      Vor der eigentlichen Division wird ein berschlag durchgefhrt. Dazu
      werden die ersten 8 Stellen von faktor2_divident[] und szhz_divisor[] in
      zehnstellige Integerzahlen umgewandelt (Fhrende Nullen fallen hier nicht
      ins Gewicht. Die Umwandlung von szhz[] muss nur einmal erfolgen und wird
      deshalb vor Eintritt in die Schleife durchgefhrt.) und dividiert.
      Das Ergebnis entspricht in der berwiegenden
      Zahl der Flle auch dem Ergebnis der Division der gesamten Arrays.
      Anschlieend erfolgt eine berprfung, ob das Ergebnis wirklich
      bereinstimmt.
      Hier ist nur eine Abweichung mglich: das Ergebnis liegt um 1 zu hoch.
      Dieser Fehler tritt auf, wenn der berschlag die Zahlen nicht hinreichend
      reprsentiert und erst die folgenden Stellen, die beim berschlag nicht
      betrachtet wurden zeigen, dass der Divisor doch ein wenig zu gro ist.
      Bsp.: Divident:           46914
            Dividentberschlag: 468
            Divisor:            23499
            Divisorberschlag:  234

      Der berschlag ergibt glatt 2, obwohl der Divisor nur einmal ganz in den
      Dividenten passt. Dieser Fehler kann leicht korrigiert werden: das
      richtige Ergebnis dieses Divisionsschrittes = berschlagsergebnis-1.

      Danach wird zurckmultipliziert und ber eine Subtraktion der Rest
      bestimmt und in faktor2_divident[] geschrieben. */

      // Bildung des berschlags fr den aktuellen faktor2_divident
      if (szhz_laenge>=4)
        faktor2_divident_ueberschlag=10000*faktor2_divident[0]+
                                     1000*faktor2_divident[1]+
                                     100*faktor2_divident[2]+
                                     10*faktor2_divident[3]+
                                     faktor2_divident[4];
        else
          {
          faktor2_divident_ueberschlag=0;
          for (zaehler_lokal=0; zaehler_lokal<=(szhz_laenge); zaehler_lokal++)
            {
            naechste_stelle=faktor2_divident[zaehler_lokal];
            for (zehnerpotenz=(szhz_laenge-zaehler_lokal); zehnerpotenz>=1; zehnerpotenz--)
              naechste_stelle*=10;
            faktor2_divident_ueberschlag+=naechste_stelle;
            };
          };

      // berschlagsrechnung
      schreibe=faktor2_divident_ueberschlag/szhz_divisor_ueberschlag;

      // Rckrechnung durch Multiplikation schreibe*szhz_divisor[]
      merke=0;
      for (zaehler_lokal=(szhz_laenge-1); zaehler_lokal>=0; zaehler_lokal--)
        {
        zwischenergebnis=szhz_divisor[zaehler_lokal]*schreibe;
        zwischenergebnis+=merke;
        rueckrechnung[zaehler_lokal+1]=zwischenergebnis%10;
        merke=(zwischenergebnis-zwischenergebnis%10)/10;
        };
      rueckrechnung[0]=merke;

      /* berprfung der berschlagsrechnung, nur ntig, wenn durch das
      Abschneiden */
      if (faktor2_divident_ueberschlag < ((szhz_divisor_ueberschlag+1)*schreibe))
        {
        if (kleiner_als(faktor2_divident, rueckrechnung, (szhz_laenge+1), 0))
        /* Der dritte Parameter gibt die Lnge der beiden Arrays an.
        Der vierte Parameter (0) gibt an, dass die Arrays gleich viele Elemente haben.
        Daraus leitet die Funktion die Gre des ebenso groen zweiten Arrays ab. 
        Diese etwas undurchsichtigen Parameter vereinfachen und beschleunigen
        die sehr hufig aufgerufene Funktion kleiner_als. */
          {
          schreibe-=1;
          // und neue Rckrechnung
          merke=0;
          for (zaehler_lokal=(szhz_laenge-1); zaehler_lokal>=0; zaehler_lokal--)
            {
            zwischenergebnis=szhz_divisor[zaehler_lokal]*schreibe;
            zwischenergebnis+=merke;
            rueckrechnung[zaehler_lokal+1]=zwischenergebnis%10;
            merke=(zwischenergebnis-zwischenergebnis%10)/10;
            };
          rueckrechnung[0]=merke;
          };
//        cout<<endl<<"UUU"<<endl; // Wurde kleiner_als zur berprfung genutzt?
        };
        
      // Bestimmung des neuen faktor2_divident=faktor2_divident-rueckrechnung
      char rest[szhz_laenge+1];
      merke=0;
      for (zaehler_lokal=(szhz_laenge); zaehler_lokal>=0; zaehler_lokal--)
        {
        if (faktor2_divident[zaehler_lokal]>=(rueckrechnung[zaehler_lokal]+merke))
          {
          rest[zaehler_lokal]=faktor2_divident[zaehler_lokal]-(rueckrechnung[zaehler_lokal]+merke);
          merke=0;
          }
          else
          {
          rest[zaehler_lokal]=(faktor2_divident[zaehler_lokal]+10)-(rueckrechnung[zaehler_lokal]+merke);
          merke=1;
          }
        };
      for (zaehler_lokal=0; zaehler_lokal<=szhz_laenge; zaehler_lokal++)
        faktor2_divident[zaehler_lokal]=rest[zaehler_lokal];
      };

  // Aufzeichnung des Divisionsergebnisses
  quotient[quotient_stelle]=schreibe;
  quotient_stelle++;

  // Bestimmung der letzten nicht mehr vernderten Stelle
  genau_max=0;
  while (quotient[genau_max] == 0)
    genau_max++;
  genau_max--;   // quotient[x+1] + pi[x] kann sich noch auf die
                 // Stelle pi[x-1] auswirken
  };

// Addiere quotient[] zu pi[]
   merke=0;
   for (zaehler_lokal=(STELLENZAHL-1); zaehler_lokal>=0; zaehler_lokal--)
     {
     zwischenergebnis=(*(pi+zaehler_lokal))+quotient[zaehler_lokal];
     zwischenergebnis+=merke;
     verbesserung[zaehler_lokal]=zwischenergebnis%10;
     merke=(zwischenergebnis-zwischenergebnis%10)/10;
     };

for (int i=0; i<STELLENZAHL; i++)  // pi=verbesserung bzw. pi=&verbesserung[0] nicht mglich wegen Referenz auf zerstrt sein werdende Variable
  *(pi+i)=verbesserung[i];

}  //  Ende der Funktion verbessere_pi


void berechne(void)
{
int zaehler_lokal;

cout<<"Zaehlerstand vor Beginn der Berechnung: "<<zaehler<<".\n";
cout<<"Rechenvorgang beginnt.\n\n";
cout<<"Aktueller Stand der Berechnung:\n\n";

while ((genau_max<GENAUIGKEIT) && (statusflag!='x'))  // Hier wird die Anzahl der Durchlufe,
  {                            // also die Gre von i bestimmt.
  zaehler++;                   // Wenn genau_max den angestrebten Wert GENAUIGKEIT erreicht,
                               // wird die while-Schleife kein weiteres Mal
                               // durchlaufen.
  erhoehe_szhz();              // Anpassung von szhz an aktuellen Zhlerstand
  verbessere_pi();
  if (statusflag != 'x')
    cout<<"Zaehler: "<<zaehler<<", letzte berechnete Stelle: "<<static_cast<int>(*(pi+genau_max-1))<<" ( = Nr. "<<genau_max<<").\r";
  if (zaehler%10 == 0) zwischenspeichern();

  };


}  //  Ende der Funktion berechne

/** Ende des Berechnungsteils **/


