PROGRAM Rechts_und_links;
USES CRT,DOS;

VAR TasteLinks, TasteRechts, Eingabe  : CHAR;
    User                              : STRING;
    Vorgabe, Versuche, Fehler, Treffer, Ton: WORD;
    Zeit                              : REAL;
    Wiederholung, Abbruch             : BOOLEAN;


FUNCTION Minim (Input: CHAR):CHAR;
BEGIN
 IF (Input >= 'A') AND (Input <= 'Z') THEN DEC(Input,(-32));
 Minim:= Input;
END;

FUNCTION DownCaseStr(S: STRING): STRING;
VAR
  I: INTEGER;
BEGIN
  FOR I := 1 TO Length(S) DO IF (S[I] >= 'A') AND (S[I] <= 'Z') THEN DEC(S[I], (-32));
  DownCaseStr := S;
END;

PROCEDURE Einleitung;
BEGIN
     CLRSCR;
     WRITELN('Dieses Programm soll die Fhigkeit schulen, mit den Wrtern "rechts" bzw.');
     WRITELN ('"links" die entsprechenden Richtungen zu verbinden.');
     WRITELN;
     WRITELN('Mit wem habe ich es zu tun?');
     WRITELN;
     TEXTCOLOR (Yellow); READLN(User); TEXTCOLOR (White);
     WRITELN;
     WRITELN(' Aha. Hallo ',User,'.');

     GOTOXY (1,9);
     WRITELN (' Bitte such dir eine Taste auf dem ');
     WRITELN ('   linken Teil der Tastatur aus!   ');
     WRITELN;
     WRITE ('    (Irgendwo auf '); TEXTCOLOR (Red+Blink); WRITE ('DIESER'); TEXTCOLOR (White); WRITELN (' Seite.)   ');
     TEXTCOLOR (White);
     WRITELN;
     WRITELN (' Diese Taste wirst du drcken, wenn');
     WRITELN ('   nachher auf dem Bildschirm die   ');
     WRITE   ('    Anweisung  LINKS  erscheint.    ');
     GOTOXY(17,18);
     REPEAT TasteLinks:= READKEY UNTIL TasteLinks <> ' ';
     TEXTCOLOR (Yellow); WRITELN (TasteLinks); TEXTCOLOR (White);
     GOTOXY (19,12); TEXTCOLOR (Red); WRITE ('DIESER'); TEXTCOLOR (White);     WRITELN;
     GOTOXY (45,9);  WRITE ('Und jetzt das ganze fr die');
     GOTOXY (45,10); WRITE ('       rechte Seite!       ');
     GOTOXY (58,12); TEXTCOLOR (Red+Blink); WRITE ('HIER'); TEXTCOLOR (White);
     GOTOXY (58,18);
     REPEAT TasteRechts:= READKEY UNTIL (TasteRechts <> ' ') AND (TasteRechts <> TasteLinks);
     TEXTCOLOR (Yellow); WRITE (TasteRechts);  TEXTCOLOR (White);
     GOTOXY (58,12); TEXTCOLOR (Red); WRITE ('HIER'); TEXTCOLOR (White);
     GOTOXY (17,21); WRITE ('Sollen die Signaltne aktiviert werden? (j/n)');
     REPEAT
           Eingabe:= Minim(READKEY);
           IF Eingabe = 'j' THEN Ton:= 1 ELSE Ton:= 0;
     UNTIL (Eingabe = 'j') OR (Eingabe = 'n');

END;

PROCEDURE Richtig;
BEGIN
     SOUND (205*Ton);
     GOTOXY (37,14); WRITELN ('Richtig!');
     Treffer:= Treffer+1;
     Wiederholung:= FALSE;
     DELAY (1000);
     NOSOUND;
     DELAY (4000);
END;

PROCEDURE Falsch;
BEGIN
     SOUND (40*Ton);
     GOTOXY (31,14); WRITE ('Das ist leider falsch.');
     Fehler:= Fehler+1;
     Wiederholung:= FALSE;
     DELAY (1000);
     NOSOUND;
     DELAY (4000);
END;

PROCEDURE Vertippt;
VAR Nachfrage: CHAR;

BEGIN
     IF Eingabe = ' ' THEN
      BEGIN
           CLRSCR;
           GOTOXY (16,14); WRITE ('Soll das Programm wirklich abgebrochen werden? (j/n) ');
           REPEAT
                 Nachfrage:= Minim(READKEY);
                 IF Nachfrage = 'j' THEN
                  BEGIN
                       Abbruch:= TRUE;
                       Wiederholung:= FALSE;
                  END
                 ELSE Wiederholung:= TRUE;
           UNTIL (Nachfrage = 'j') OR (Nachfrage = 'n');
      END
     ELSE
      BEGIN
           GOTOXY (24,14); WRITE ('Du hast eine falsche Taste gedrckt.');
           Wiederholung:= TRUE;
           DELAY (5000);
      END;
END;

PROCEDURE Einzelrunde;
VAR Stunde1, Minute1, Sekunde1, Hundertstel1, Stunde2, Minute2, Sekunde2, Hundertstel2: WORD;
    Zwzeit: REAL;
BEGIN
     RANDOMIZE;
     Vorgabe:= RANDOM(2);
     Wiederholung:= TRUE;
     Eingabe:= TasteLinks;       { Ermglicht den Signalton bei der Ausgabe der ersten Aufgabe, trotz der Festlegung der }
     IF KEYPRESSED THEN          { Variablen Eingabe auf 'j' oder 'n' in der PROCEDURE Einleitung und der Unterscheidung }
      BEGIN                      { etwas tiefer, verhindert aber zugleich den Signalton bei der Stellung der Aufgabe,    }
           Eingabe:= READKEY;                   {wenn zuvor schon die  LEERTASTE  zum Abbruch gedrckt wurde.            }
           IF Eingabe = ' ' THEN Vertippt;
      END;

     WHILE Wiederholung = TRUE DO
      BEGIN
           CLRSCR;
           GOTOXY (5,2); WRITE ('Taste fr LINKS: ',TasteLinks);
           GOTOXY (30,2); WRITE ('Abbruch: LEERTASTE');
           GOTOXY (55,2); WRITE ('Taste fr RECHTS: ',TasteRechts);
           GOTOXY (5,23); WRITE ('Versuche:',Fehler+Treffer:4);
           GOTOXY (5,24); WRITE ('Treffer :',Treffer:4);
           GOTOXY (5,25); WRITE ('Fehler  :',Fehler:4);
           GOTOXY (38,12);
           IF (Eingabe = TasteLinks) OR (Eingabe=TasteRechts) THEN
            BEGIN
                 DELAY (2250);       { Unterscheidung, die Verhindert, da der Signal- }
                 SOUND (1500*Ton);   { ton und das Bildschirmflackern auch erfolgt,    }
                 DELAY (100);        { wenn nur eine falsche Taste gedrckt wurde.     }
            END;                     { Der Benutzer soll so erkennen, da sich die Aufgabe nicht gendert hat. }
           GETTIME (Stunde1,Minute1,Sekunde1,Hundertstel1);
           IF Vorgabe = 0 THEN
            BEGIN
                 WRITELN ('LINKS  ');
                 NOSOUND;
                 Eingabe:=READKEY;
                 GETTIME (Stunde2,Minute2,Sekunde2,Hundertstel2);
                 IF Eingabe = TasteLinks THEN Richtig ELSE IF Eingabe = TasteRechts THEN Falsch ELSE Vertippt;
            END
           ELSE
            BEGIN
                 WRITELN ('RECHTS ');
                 NOSOUND;
                 Eingabe:= READKEY;
                 GETTIME (Stunde2,Minute2,Sekunde2,Hundertstel2);
                 IF Eingabe = TasteRechts THEN Richtig ELSE IF Eingabe = TasteLinks THEN Falsch ELSE Vertippt;
           END;
          Zwzeit:=Stunde2*360+Minute2*6+Sekunde2/10+Hundertstel2/1000-Stunde1*360-Minute1*6-Sekunde1/10-Hundertstel1/1000;
      END;
     IF Eingabe <> ' ' THEN Zeit:= Zeit+Zwzeit*10; { <- verhindert, da die Bedenkzeit zwischen     }
                                                   { letzter Aufgabe und Abbruch mitgerechnet wird. }
END;

PROCEDURE Uebung;
BEGIN
     GOTOXY (27,24);
     WRITE ('So, die bung beginnt.');
     DELAY (4000);
     WRITELN (' Jetzt.');
     DELAY (3500);
     Fehler:= 0; Treffer:= 0;
     Abbruch:= FALSE;
     Zeit:= 0;
     REPEAT Einzelrunde UNTIL Abbruch = TRUE;
END;

PROCEDURE Auswertung;
BEGIN
     CLRSCR;
     IF Fehler+Treffer > 0 THEN
      BEGIN
           GOTOXY (5,10); WRITELN ('Das Programm wurde abgebrochen. Hier kommt die Auswertung.');
           GOTOXY (10,12); WRITELN ('Anzahl der Versuche:',Fehler+Treffer:4);
           GOTOXY (10,13); WRITELN ('Anzahl der Treffer :',Treffer:4);
           GOTOXY (10,14); WRITELN ('Anzahl der Fehler  :',Fehler:4);
           GOTOXY (10,16); WRITELN ('Das entspricht einer Trefferquote von ',(Treffer*100/(Treffer+Fehler)):3:1,' %.');
           GOTOXY (5,18); WRITELN ('Die Bedenkzeit betrug im Durchschnitt ',Zeit/(Treffer+Fehler):3:1,' Sekunden pro Aufgabe.')
      END
     ELSE
      BEGIN
           GOTOXY (5,12); WRITE ('Das Programm wurde ohne einen Versuch abgebrochen. Die Auswertung entfllt.');
      END;
END;

BEGIN { Hauptprogramm }
     TEXTBACKGROUND (Blue);
     TEXTCOLOR (White);
     Einleitung;
     Uebung;
     TEXTBACKGROUND (Black);
     TEXTCOLOR (White);
     Auswertung;
     GOTOXY (25,25); WRITELN ('Bitte die  ENTER - Taste drcken.');
     READLN;
END.