unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, Grids;

type
  TFHauptfenster = class(TForm)
    PageControl1: TPageControl;
    TSSchnell: TTabSheet;
    TSPhysik: TTabSheet;
    LLeistung: TLabel;
    ELeistung: TEdit;
    LGleich1: TLabel;
    EkW: TEdit;
    LkW: TLabel;
    LEnergieverbrauch: TLabel;
    LEStunde: TLabel;
    EEStunde: TEdit;
    LkWhStunde: TLabel;
    LETag: TLabel;
    EETag: TEdit;
    LkWhTag: TLabel;
    LEJahr: TLabel;
    EEJahr: TEdit;
    LkWhJahr: TLabel;
    BBeenden: TButton;
    TSProgramm: TTabSheet;
    LStromkosten: TLabel;
    EKJahr: TEdit;
    EKTag: TEdit;
    EKStunde: TEdit;
    LEuroStunde: TLabel;
    LEuroTag: TLabel;
    LEuroJahr: TLabel;
    LPreis: TLabel;
    ECent: TEdit;
    LCO2: TLabel;
    LZwei: TLabel;
    ECO2Jahr: TEdit;
    ECO2Tag: TEdit;
    ECO2Stunde: TEdit;
    LkgStunde: TLabel;
    LkgTag: TLabel;
    LkgJahr: TLabel;
    LSternoben: TLabel;
    Label2: TLabel;
    MInfo: TMemo;
    MPhysik: TMemo;
    Memo1: TMemo;
    LErklaerungen: TLabel;
    LFormeln: TLabel;
    LEinleitung: TLabel;
    Label1: TLabel;
    TSVergleich: TTabSheet;
    Label3: TLabel;
    Label4: TLabel;
    Label5: TLabel;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    Label10: TLabel;
    Label11: TLabel;
    Label12: TLabel;
    EPreisA: TEdit;
    EStrompreis: TEdit;
    Label14: TLabel;
    Label15: TLabel;
    Memo2: TMemo;
    BAuswerten: TButton;
    EPreisB: TEdit;
    ENutzungB: TEdit;
    EWB: TEdit;
    EhB: TEdit;
    EkWhA: TEdit;
    ENutzungA: TEdit;
    EWA: TEdit;
    EhA: TEdit;
    EkWhB: TEdit;
    EJahrB: TEdit;
    EJahrA: TEdit;
    Label16: TLabel;
    BNeu: TButton;
    procedure BBeendenClick(Sender: TObject);
    procedure ELeistungChange(Sender: TObject);
    procedure ECentChange(Sender: TObject);
    procedure EPreisAChange(Sender: TObject);
    procedure EPreisBChange(Sender: TObject);
    procedure EkWhAChange(Sender: TObject);
    procedure EkWhBChange(Sender: TObject);
    procedure ENutzungAChange(Sender: TObject);
    procedure ENutzungBChange(Sender: TObject);
    procedure EWAChange(Sender: TObject);
    procedure EWBChange(Sender: TObject);
    procedure EhAChange(Sender: TObject);
    procedure EhBChange(Sender: TObject);
    procedure EStrompreisChange(Sender: TObject);
    procedure BAuswertenClick(Sender: TObject);
    procedure EJahrAChange(Sender: TObject);
    procedure EJahrBChange(Sender: TObject);
    procedure BNeuClick(Sender: TObject);


  private
    { Private-Deklarationen }
  public
    { Public-Deklarationen }
  end;

var
  FHauptfenster: TFHauptfenster;
  AlterLeistungsText: string = '';  {stellt alte Eingabe wieder her, wenn keine Zahl eingegeben wurde}
  AlterPreisText: string = '';  {stellt alte Eingabe wieder her, wenn keine Zahl eingegeben wurde}

implementation

{$R *.dfm}


procedure TFHauptfenster.BBeendenClick(Sender: TObject);
begin
close();
end;

procedure TFHauptfenster.ELeistungChange(Sender: TObject);

var Leistung, Preis: real;


begin
  try
    Leistung:=StrToFloat(ELeistung.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         if ELeistung.Text='' then Leistung:=0 else  {Abfrage ntig, um Edits wieder vollkommen leer zu machen, wenn alle Zahlen gelscht wurden}
                                                                 begin
                                                                   ELeistung.Text:=AlterLeistungsText;
                                                                   ELeistung.SelStart:=Length(ELeistung.Text);
                                                                   if ELeistung.Text = '' then Leistung:=0 else Leistung:=StrToFloat(ELeistung.Text);  {Abfrage ntig, um Eingabe von Buchstaben in leeren Edit abzufangen}
                                                                 end;
                       end;
  end;
  AlterLeistungsText:=ELeistung.Text;
  if Leistung <> 0 then   {wenn Zahlen eingegeben wurden Ergebnisse berechnen und ausgeben}
                     begin
                       EkW.Text:=FloatToStrF(round(Leistung)/1000,ffFixed,5,3);
                       EEStunde.Text:=FloatToStrF(round(Leistung)/1000,ffFixed,5,3);
                       EETag.Text:=FloatToStrF(round(Leistung*24)/1000,ffFixed,5,3);
                       EEJahr.Text:=FloatToStrF(round(Leistung*24*365)/1000,ffFixed,5,3);

                       {Die Erzeugung einer kWh Strom erzeugt 682 g CO2}
                       ECO2Stunde.Text:=FloatToStrF(round(Leistung*0.682)/1000,ffFixed,5,3);
                       ECO2Tag.Text:=FloatToStrF(round(Leistung*24*0.682)/1000,ffFixed,5,3);
                       ECO2Jahr.Text:=FloatToStrF(round(Leistung*24*365*0.682)/1000,ffFixed,5,3);
                     end
                   else if ELeistung.Text = '' then   {wenn Eingabe leer ist alles leer lassen}
                                                 begin
                                                   EkW.Text:='';
                                                   EEStunde.Text:='';
                                                   EETag.Text:='';
                                                   EEJahr.Text:='';


                                                   ECO2Stunde.Text:='';
                                                   ECO2Tag.Text:='';
                                                   ECO2Jahr.Text:='';
                                                 end
                                               else   {wenn Eingabe '0' ist alles '0' setzen}
                                                 begin
                                                   EkW.Text:='0';
                                                   EEStunde.Text:='0';
                                                   EETag.Text:='0';
                                                   EEJahr.Text:='0';


                                                   ECO2Stunde.Text:='0';
                                                   ECO2Tag.Text:='0';
                                                   ECO2Jahr.Text:='0';
                                                   end;


  {Bei nderung der Leistung sollen sich die Stromkosten auch ndern}
  try
    Preis:=StrToFloat(ECent.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         if ECent.Text='' then Preis:=0 else  {Abfrage ntig, um Edits wieder vollkommen leer zu machen, wenn alle Zahlen gelscht wurden}
                                                          begin
                                                            ECent.Text:=AlterPreisText;
                                                            ECent.SelStart:=Length(ECent.Text);
                                                            if ECent.Text = '' then Preis:=0 else Preis:=StrToFloat(ECent.Text);  {Abfrage ntig, um Eingabe von Buchstaben in leeren Edit abzufangen}
                                                          end;
                       end;
  end;
  AlterPreisText:=ECent.Text;
  if (Preis <> 0) AND (ELeistung.Text <> '') then   {wenn Zahlen eingegeben wurden Ergebnisse berechnen und ausgeben}
                     begin
                       EKStunde.Text:=FloatToStrF(round(Preis*StrToFloat(EEStunde.Text))/100,ffFixed,5,2);
                       EKTag.Text:=FloatToStrF(round(Preis*StrToFloat(EETag.Text))/100,ffFixed,5,2);
                       EKJahr.Text:=FloatToStrF(round(Preis*StrToFloat(EEJahr.Text))/100,ffFixed,5,2);
                     end
                   else if (ECent.Text = '') OR (ELeistung.Text = '')  then   {wenn Eingaben leer sind alles leer lassen}
                                                 begin
                                                   EKStunde.Text:='';
                                                   EKTag.Text:='';
                                                   EKJahr.Text:='';
                                                 end
                                               else   {wenn Eingabe '0' ist alles '0' setzen}
                                                 begin
                                                   EKStunde.Text:='0';
                                                   EKTag.Text:='0';
                                                   EKJahr.Text:='0';
                                                 end;

end; {Ende von procedure TFHauptfenster.ELeistungChange(Sender: TObject);}


procedure TFHauptfenster.ECentChange(Sender: TObject);

var Preis: real;


begin
  try
    Preis:=StrToFloat(ECent.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         if ECent.Text='' then Preis:=0 else  {Abfrage ntig, um Edits wieder vollkommen leer zu machen, wenn alle Zahlen gelscht wurden}
                                                          begin
                                                            ECent.Text:=AlterPreisText;
                                                            ECent.SelStart:=Length(ECent.Text);
                                                            if ECent.Text = '' then Preis:=0 else Preis:=StrToFloat(ECent.Text);  {Abfrage ntig, um Eingabe von Buchstaben in leeren Edit abzufangen}
                                                          end;
                       end;
  end;
  AlterPreisText:=ECent.Text;
  if (Preis <> 0) AND (ELeistung.Text <> '') then   {wenn Zahlen eingegeben wurden Ergebnisse berechnen und ausgeben}
                     begin
                       EKStunde.Text:=FloatToStrF(round(Preis*StrToFloat(EEStunde.Text))/100,ffFixed,5,2);
                       EKTag.Text:=FloatToStrF(round(Preis*StrToFloat(EETag.Text))/100,ffFixed,5,2);
                       EKJahr.Text:=FloatToStrF(round(Preis*StrToFloat(EEJahr.Text))/100,ffFixed,5,2);
                     end
                   else if (ECent.Text = '') OR (ELeistung.Text = '') then   {wenn Eingaben leer sind alles leer lassen}
                                                 begin
                                                   EKStunde.Text:='';
                                                   EKTag.Text:='';
                                                   EKJahr.Text:='';
                                                 end
                                               else   {wenn Eingabe '0' ist alles '0' setzen}
                                                 begin
                                                   EKStunde.Text:='0';
                                                   EKTag.Text:='0';
                                                   EKJahr.Text:='0';
                                                 end;


end; {Ende von procedure TFHauptfenster.ECentChange(Sender: TObject);}






procedure TFHauptfenster.EPreisAChange(Sender: TObject);

var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EPreisA.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EPreisA.Text:='';
                         Eingabe:=0;
                       end;
  end;

end;


procedure TFHauptfenster.EPreisBChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EPreisB.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EPreisB.Text:='';
                         Eingabe:=0;
                       end;
  end;
end;


procedure TFHauptfenster.EkWhAChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EkWhA.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EkWhA.Text:='';
                         Eingabe:=0;
                         if ENutzungA.Text='' then
                                           begin
                                             EWA.Color := $00C2EEFE;
                                             EhA.Color := $00C2EEFE;
                                             EJahrA.Color := $00C2EEFE;
                                             EWA.ReadOnly := false;
                                             EhA.ReadOnly := false;
                                             EJahrA.ReadOnly := false;
                                             EWA.TabStop := true;
                                             EhA.TabStop := true;
                                             EJahrA.TabStop := true;
                                           end;
                       end;
  end;
  if EkWhA.Text<>'' then
                      begin
                        EWA.Color := clWindow;
                        EhA.Color := clWindow;
                        EJahrA.Color := clWindow;
                        EWA.ReadOnly := true;
                        EhA.ReadOnly := true;
                        EJahrA.ReadOnly := true;
                        EWA.TabStop := false;
                        EhA.TabStop := false;
                        EJahrA.TabStop := false;
                      end;




end;


procedure TFHauptfenster.EkWhBChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EkWhB.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EkWhB.Text:='';
                         Eingabe:=0;
                         if ENutzungB.Text='' then
                                           begin
                                             EWB.Color := $00C2EEFE;
                                             EhB.Color := $00C2EEFE;
                                             EJahrB.Color := $00C2EEFE;
                                             EWB.ReadOnly := false;
                                             EhB.ReadOnly := false;
                                             EJahrB.ReadOnly := false;
                                             EWB.TabStop := true;
                                             EhB.TabStop := true;
                                             EJahrB.TabStop := true;
                                           end;
                       end;
  end;
  if EkWhB.Text<>'' then
                      begin
                        EWB.Color := clWindow;
                        EhB.Color := clWindow;
                        EJahrB.Color := clWindow;
                        EWB.ReadOnly := true;
                        EhB.ReadOnly := true;
                        EJahrB.ReadOnly := true;
                        EWB.TabStop := false;
                        EhB.TabStop := false;
                        EJahrB.TabStop := false;
                      end;

end;


procedure TFHauptfenster.ENutzungAChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(ENutzungA.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         ENutzungA.Text:='';
                         Eingabe:=0;
                         if EkWhA.Text='' then
                                           begin
                                             EWA.Color := $00C2EEFE;
                                             EhA.Color := $00C2EEFE;
                                             EJahrA.Color := $00C2EEFE;
                                             EWA.ReadOnly := false;
                                             EhA.ReadOnly := false;
                                             EJahrA.ReadOnly := false;
                                             EWA.TabStop := true;
                                             EhA.TabStop := true;
                                             EjahrA.TabStop := true;
                                           end;
                       end;
  end;
  if ENutzungA.Text<>'' then
                      begin
                        EWA.Color := clWindow;
                        EhA.Color := clWindow;
                        EJahrA.Color := clWindow;
                        EWA.ReadOnly := true;
                        EhA.ReadOnly := true;
                        EJahrA.ReadOnly := true;
                        EWA.TabStop := false;
                        EhA.TabStop := false;
                        EJahrA.TabStop := false;
                      end;
end;



procedure TFHauptfenster.ENutzungBChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(ENutzungB.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         ENutzungB.Text:='';
                         Eingabe:=0;
                         if EkWhB.Text='' then
                                           begin
                                             EWB.Color := $00C2EEFE;
                                             EhB.Color := $00C2EEFE;
                                             EJahrB.Color := $00C2EEFE;
                                             EWB.ReadOnly := false;
                                             EhB.ReadOnly := false;
                                             EJahrB.ReadOnly := false;
                                             EWB.TabStop := true;
                                             EhB.TabStop := true;
                                             EJahrB.TabStop := true;
                                           end;
                       end;
  end;
  if ENutzungB.Text<>'' then
                      begin
                        EWB.Color := clWindow;
                        EhB.Color := clWindow;
                        EJahrB.Color := clWindow;
                        EWB.ReadOnly := true;
                        EhB.ReadOnly := true;
                        EJahrB.ReadOnly := true;
                        EWB.TabStop := false;
                        EhB.TabStop := false;
                        EJahrB.TabStop := false;
                      end;

end;


procedure TFHauptfenster.EWAChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EWA.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EWA.Text:='';
                         Eingabe:=0;
                         if EhA.Text='' then
                                     begin
                                       EkWhA.Color := $00C2EEFE;
                                       ENutzungA.Color := $00C2EEFE;
                                       EJahrA.Color := $00C2EEFE;
                                       EkWhA.ReadOnly := false;
                                       ENutzungA.ReadOnly := false;
                                       EJahrA.ReadOnly := false;
                                       EkWhA.TabStop := true;
                                       ENutzungA.TabStop := true;
                                       EJahrA.TabStop := true;
                                     end;
                       end;
  end;
  if EWA.Text<>'' then
                      begin
                        EkWhA.Color := clWindow;
                        ENutzungA.Color := clWindow;
                        EJahrA.Color := clWindow;
                        EkWhA.ReadOnly := true;
                        ENutzungA.ReadOnly := true;
                        EJahrA.ReadOnly := true;
                        EkWhA.TabStop := false;
                        ENutzungA.TabStop := false;
                        EJahrA.TabStop := false;
                      end;

end;


procedure TFHauptfenster.EWBChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EWB.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EWB.Text:='';
                         Eingabe:=0;
                         if EhB.Text='' then
                                     begin
                                       EkWhB.Color := $00C2EEFE;
                                       ENutzungB.Color := $00C2EEFE;
                                       EJahrB.Color := $00C2EEFE;
                                       EkWhB.ReadOnly := false;
                                       ENutzungB.ReadOnly := false;
                                       EJahrB.ReadOnly := false;
                                       EkWhB.TabStop := true;
                                       ENutzungB.TabStop := true;
                                       EJahrB.TabStop := true;
                                     end;
                       end;
  end;
  if EWB.Text<>'' then
                      begin
                        EkWhB.Color := clWindow;
                        ENutzungB.Color := clWindow;
                        EJahrB.Color := clWindow;
                        EkWhB.ReadOnly := true;
                        ENutzungB.ReadOnly := true;
                        EJahrB.ReadOnly := true;
                        EkWhB.TabStop := false;
                        ENutzungB.TabStop := false;
                        EJahrB.TabStop := false;
                      end;

end;


procedure TFHauptfenster.EhAChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EhA.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EhA.Text:='';
                         Eingabe:=0;
                         if EWA.Text='' then
                                     begin
                                       EkWhA.Color := $00C2EEFE;
                                       ENutzungA.Color := $00C2EEFE;
                                       EJahrA.Color := $00C2EEFE;
                                       EkWhA.ReadOnly := false;
                                       ENutzungA.ReadOnly := false;
                                       EJahrA.ReadOnly := false;
                                       EkWhA.TabStop := true;
                                       ENutzungA.TabStop := true;
                                       EJahrA.TabStop := true;
                                     end;
                       end;
  end;
  if EhA.Text<>'' then
                      begin
                        EkWhA.Color := clWindow;
                        ENutzungA.Color := clWindow;
                        EJahrA.Color := clWindow;
                        EkWhA.ReadOnly := true;
                        ENutzungA.ReadOnly := true;
                        EJahrA.ReadOnly := true;
                        EkWhA.TabStop := false;
                        ENutzungA.TabStop := false;
                        EJahrA.TabStop := false;
                     end;

end;


procedure TFHauptfenster.EhBChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EhB.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EhB.Text:='';
                         Eingabe:=0;
                         if EWB.Text='' then
                                     begin
                                       EkWhB.Color := $00C2EEFE;
                                       ENutzungB.Color := $00C2EEFE;
                                       EJahrB.Color := $00C2EEFE;
                                       EkWhB.ReadOnly := false;
                                       ENutzungB.ReadOnly := false;
                                       EJahrB.ReadOnly := false;
                                       EkWhB.TabStop := true;
                                       ENutzungB.TabStop := true;
                                       EJahrB.TabStop := true;
                                     end;
                       end;
  end;
  if EhB.Text<>'' then
                      begin
                        EkWhB.Color := clWindow;
                        ENutzungB.Color := clWindow;
                        EJahrB.Color := clWindow;
                        EkWhB.ReadOnly := true;
                        ENutzungB.ReadOnly := true;
                        EJahrB.ReadOnly := true;
                        EkWhB.TabStop := false;
                        ENutzungB.TabStop := false;
                        EJahrB.TabStop := false;
                      end;

end;


procedure TFHauptfenster.EStrompreisChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EStrompreis.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EStrompreis.Text:='';
                         Eingabe:=0;
                       end;
  end;

end;




procedure TFHauptfenster.BAuswertenClick(Sender: TObject);

var JahresverbrauchA, JahresverbrauchB, PreisA, PreisB, Zeit, Strompreis: real;

begin

{berprfung, ob Eingaben ausreichend}

{Wenn nicht, ...}

  if (EPreisA.Text='') or
     (((EkWhA.Text='') or (ENutzungA.Text='')) and ((EWA.Text='') or (EhA.Text='')) and (EJahrA.Text='')) or

     (EPreisB.Text='') or
     (((EkWhB.Text='') or (ENutzungB.Text='')) and ((EWB.Text='') or (EhB.Text='')) and (EJahrB.Text='')) or

     (EStrompreis.Text='')
  then
    begin
      Memo2.Clear;
      Memo2.Lines[0] := 'Bitte geben Sie die fehlenden Werte in den gelben Feldern ein.'
    end

 {Wenn Eingaben ausreichend, ...}

  else
    begin
      Memo2.Clear;



{Berechnung und Ausgabe des Jahresverbrauches}

      if EkWhA.Text='' then
                         if EWA.Text='' then JahresverbrauchA := StrToFloat(EJahrA.Text)
                                        else JahresverbrauchA := (StrToFloat(EWA.Text))*(StrToFloat(EhA.Text)*0.052)
                         else JahresverbrauchA := (StrToFloat(EkWhA.Text))*(StrToFloat(ENutzungA.Text)*52);

      if EkWhB.Text='' then
                         if EWB.Text='' then JahresverbrauchB := StrToFloat(EJahrB.Text)
                                        else JahresverbrauchB := (StrToFloat(EWB.Text))*(StrToFloat(EhB.Text)*0.052)
                         else JahresverbrauchB := (StrToFloat(EkWhB.Text))*(StrToFloat(ENutzungB.Text)*52);

      EJahrA.Text:=FloatToStrF(round(JahresverbrauchA*10)/10,ffFixed,5,1);
      EJahrB.Text:=FloatToStrF(round(JahresverbrauchB*10)/10,ffFixed,5,1);

 {Berechnung und Ausgabe der Wirtschaftlichkeit}

      PreisA := StrToFloat(EPreisA.Text);
      PreisB := StrToFloat(EPreisB.Text);
      Strompreis := (StrToFloat(EStrompreis.Text)/100);

      if (PreisA < PreisB) and (JahresverbrauchA < JahresverbrauchB) then Memo2.Lines[0]:='Gert A ist sowohl in der Anschaffung als auch im Betrieb gnstiger als Gert B.';
      if (PreisA < PreisB) and (JahresverbrauchA = JahresverbrauchB) then Memo2.Lines[0]:='Gert A ist gnstiger in der Anschaffung als Gert B. Der Stromverbrauch ist bei beiden Gerten gleich.';
      if (PreisA < PreisB) and (JahresverbrauchA > JahresverbrauchB)
        then
          begin
            Zeit:= (PreisB-PreisA)/((JahresverbrauchA-JahresverbrauchB)*Strompreis);
            Memo2.Lines.Append('Gert A ist zwar gnstiger in der Anschaffung aber teurer im Betrieb als Gert B.');
            Memo2.Lines.Append('Nach ');
            Memo2.Lines.Add(FloatToStrF(round(Zeit*10)/10,ffFixed,5,1));
            Memo2.Lines.Add('Jahren hat sich Gert B rentiert.');
            Memo2.Lines.Add('In dieser Zeit wurde mit dem Gert B der Aussto von');
            Memo2.Lines.Add(FloatToStrF(round(Zeit*(JahresverbrauchA-JahresverbrauchB)*0.682)/10,ffFixed,5,1));
            Memo2.Lines.Add('kg CO2 verhindert.');
          end;

      if (PreisA = PreisB) and (JahresverbrauchA < JahresverbrauchB) then Memo2.Lines[0]:='Die Gerte haben den gleichen Preis, aber Gert A ist gnstiger im Betrieb als Gert B.';
      if (PreisA = PreisB) and (JahresverbrauchA = JahresverbrauchB) then Memo2.Lines[0]:='Die Gerte stimmen in den Kosten fr Anschaffung und Betrieb berein.';
      if (PreisA = PreisB) and (JahresverbrauchA > JahresverbrauchB) then Memo2.Lines[0]:='Die Gerte haben den gleichen Preis, aber Gert B ist gnstiger im Betrieb als Gert A.';

      if (PreisA > PreisB) and (JahresverbrauchA < JahresverbrauchB)
        then
          begin
            Zeit:= (PreisB-PreisA)/((JahresverbrauchA-JahresverbrauchB)*Strompreis);
            Memo2.Lines.Append('Gert B ist zwar gnstiger in der Anschaffung aber teurer im Betrieb als Gert A.');
            Memo2.Lines.Append('Nach ');
            Memo2.Lines.Add(FloatToStrF(round(Zeit*10)/10,ffFixed,5,1));
            Memo2.Lines.Add('Jahren hat sich Gert A rentiert.');
            Memo2.Lines.Add('In dieser Zeit wurde mit dem Gert A der Aussto von');
            Memo2.Lines.Add(FloatToStrF(round(Zeit*(JahresverbrauchB-JahresverbrauchA)*0.682)/10,ffFixed,5,1));
            Memo2.Lines.Add('kg CO2 verhindert.');
          end;


      if (PreisA > PreisB) and (JahresverbrauchA = JahresverbrauchB) then Memo2.Lines[0]:='Gert B ist gnstiger in der Anschaffung als Gert A. Der Stromverbrauch ist bei beiden Gerten gleich.';
      if (PreisA > PreisB) and (JahresverbrauchA > JahresverbrauchB) then Memo2.Lines[0]:='Gert B ist sowohl in der Anschaffung als auch im Betrieb gnstiger als Gert A.';


    end;
end;





procedure TFHauptfenster.EJahrAChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EJahrA.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EJahrA.Text:='';
                         Eingabe:=0;

                         EkWhA.Color := $00C2EEFE;
                         ENutzungA.Color := $00C2EEFE;
                         EWA.Color := $00C2EEFE;
                         EhA.Color := $00C2EEFE;

                         EkWhA.ReadOnly := false;
                         ENutzungA.ReadOnly := false;
                         EWA.ReadOnly := false;
                         EhA.ReadOnly := false;

                         EkWhA.TabStop := true;
                         ENutzungA.TabStop := true;
                         EWA.TabStop := true;
                         EhA.TabStop := true;
                       end;
  end;
  if EJahrA.Text<>'' then
                      begin
                        EkWhA.Color := clWindow;
                        ENutzungA.Color := clWindow;
                        EWA.Color := clWindow;
                        EhA.Color := clWindow;

                        EkWhB.ReadOnly := true;
                        ENutzungB.ReadOnly := true;
                        EWA.ReadOnly := true;
                        EhA.ReadOnly := true;

                        EkWhA.TabStop := false;
                        ENutzungA.TabStop := false;
                        EWA.TabStop := false;
                        EhA.TabStop := false;
                      end;

end;


procedure TFHauptfenster.EJahrBChange(Sender: TObject);
var Eingabe: real;

begin
  try
    Eingabe:=StrToFloat(EJahrB.Text);
    except
      on EConvertError do    {tritt auf wenn Eingabe leer oder keine Zahl}
                       begin
                         EJahrB.Text:='';
                         Eingabe:=0;

                         EkWhB.Color := $00C2EEFE;
                         ENutzungB.Color := $00C2EEFE;
                         EWB.Color := $00C2EEFE;
                         EhB.Color := $00C2EEFE;

                         EkWhB.ReadOnly := false;
                         ENutzungB.ReadOnly := false;
                         EWB.ReadOnly := false;
                         EhB.ReadOnly := false;

                         EkWhB.TabStop := true;
                         ENutzungB.TabStop := true;
                         EWB.TabStop := true;
                         EhB.TabStop := true;
                       end;
  end;
  if EJahrB.Text<>'' then
                      begin
                        EkWhB.Color := clWindow;
                        ENutzungB.Color := clWindow;
                        EWB.Color := clWindow;
                        EhB.Color := clWindow;

                        EkWhB.ReadOnly := true;
                        ENutzungB.ReadOnly := true;
                        EWB.ReadOnly := true;
                        EhB.ReadOnly := true;

                        EkWhB.TabStop := false;
                        ENutzungB.TabStop := false;
                        EWB.TabStop := false;
                        EhB.TabStop := false;
                      end;

end;

procedure TFHauptfenster.BNeuClick(Sender: TObject);
begin
  EkWhA.Text := '';
  ENutzungA.Text := '';
  EWA.Text := '';
  EhA.Text := '';
  EJahrA.Text := '';

  EkWhA.Color := $00C2EEFE;
  ENutzungA.Color := $00C2EEFE;
  EWA.Color := $00C2EEFE;
  EhA.Color := $00C2EEFE;
  EJahrA.Color := $00C2EEFE;

  EkWhA.ReadOnly := false;
  ENutzungA.ReadOnly := false;
  EWA.ReadOnly := false;
  EhA.ReadOnly := false;
  EJahrA.ReadOnly := false;

  EkWhA.TabStop := true;
  ENutzungA.TabStop := true;
  EWA.TabStop := true;
  EhA.TabStop := true;
  EJahrA.TabStop := true;


  EkWhB.Text := '';
  ENutzungB.Text := '';
  EWB.Text := '';
  EhB.Text := '';
  EJahrB.Text := '';

  EkWhB.Color := $00C2EEFE;
  ENutzungB.Color := $00C2EEFE;
  EWB.Color := $00C2EEFE;
  EhB.Color := $00C2EEFE;
  EJahrB.Color := $00C2EEFE;

  EkWhB.ReadOnly := false;
  ENutzungB.ReadOnly := false;
  EWB.ReadOnly := false;
  EhB.ReadOnly := false;
  EJahrB.ReadOnly := false;

  EkWhB.TabStop := true;
  ENutzungB.TabStop := true;
  EWB.TabStop := true;
  EhB.TabStop := true;
  EJahrB.TabStop := true;

  EPreisA.Text := '';
  EPreisB.Text := '';
  EStrompreis.Text :='';
  Memo2.Clear;

end;


end.
